package com.izenpe.zain.cliente.pades;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartSignRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;

public class GeneracionFirmaSeriePAdES {
	public static void main(String[] args) {
		String filename = "PruebaPDF.pdf";
		try {
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartSignRequest smartSignReq = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);
			smartSignReq.setProfile(Constants.Profile.PADES);
			smartSignReq.setLanguage("es");

			String formato = Constants.SignatureFormat.BES;
			smartSignReq.setSignatureFormat(formato);
			smartSignReq.setSignatureType(Constants.SignatureType.PADES_PART3);
			
			smartSignReq.setKeySubjectName(Propiedades.ZAIN_SIGNER);
			smartSignReq.setInputPdfBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/input/"
					+ filename)));

			SmartSignResponse smartSignResp = smartSignReq.send();

			if (Constantes.RMAJOR_SUCCESS.equals((smartSignResp.getResultMajor()))
					&& smartSignResp.getResultMinor() == null) {
				ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
				String docPDF = smartSignResp.getDocumentWithSignaturePdf();

				smartSignReq = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);
				smartSignReq.setProfile(Constants.Profile.PADES);
				smartSignReq.setLanguage("es");
				smartSignReq.setSignatureFormat(formato);
				smartSignReq.setSignatureType(Constants.SignatureType.PADES_PART3);
				smartSignReq.setKeySubjectName(Propiedades.ZAIN_SIGNER);
				smartSignReq.setInputPdfBase64Data(docPDF);
				smartSignResp = smartSignReq.send();
				if (Constantes.RMAJOR_SUCCESS.equals((smartSignResp.getResultMajor()))
						&& smartSignResp.getResultMinor() == null) {
					docPDF = smartSignResp.getDocumentWithSignaturePdf();
					byte[] data = Base64.decode(docPDF);
					String destFilename = "data/output/" + filename.substring(0, filename.lastIndexOf(".")) + "-"
							 + "SignedSerie.pdf";
					ZainUtil.writeBinaryFile(destFilename, data);
					System.out.println("La firma se ha generado con xito.");
				}

			} else {
				System.out.println("Error en la Generacin de Firma:" + smartSignResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}